/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigTableModelData;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWConfigIndexTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_KEYS = 2;
    private Frame m_parentFrame = null;
    private IVWTableDefinition m_vwTableDef = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWConfigIndexTableModel(Frame parent, IVWTableDefinition tableDefinition) {
        this.m_parentFrame = parent;
        this.m_vwTableDef = tableDefinition;
        this.initialize();
    }

    public VWIndexDefinition getIndexItemAt(int nRowIndex) {
        VWConfigTableModelData tableData = null;
        tableData = this.getRowItemAt(nRowIndex);
        if (tableData != null) {
            return (VWIndexDefinition)tableData.getDefinition();
        }
        return null;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public int addItem(VWIndexDefinition indexDef) {
        VWConfigTableModelData tableData = null;
        int nRowIndex = -1;
        try {
            tableData = new VWConfigTableModelData(indexDef, 33);
            if (tableData != null) {
                this.m_rowData.addElement(tableData);
                nRowIndex = this.m_rowData.size() - 1;
                this.m_bIsModified = true;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nRowIndex;
    }

    public void deleteItem(int nRowIndex) {
        VWIndexDefinition indexDef = null;
        try {
            String name;
            indexDef = this.getIndexItemAt(nRowIndex);
            if (indexDef != null && !indexDef.isMandatorySystemIndex() && (name = indexDef.getName()) != null && name.length() > 0) {
                this.m_vwTableDef.deleteIndexDefinition(name);
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_bIsModified = true;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
    }

    public void updateItem(int nRowIndex, VWIndexDefinition indexDef) {
        VWConfigTableModelData tableData = null;
        VWIndexDefinition oldIndexDef = null;
        try {
            tableData = this.getRowItemAt(nRowIndex);
            if (tableData == null) {
                return;
            }
            oldIndexDef = (VWIndexDefinition)tableData.getDefinition();
            if (oldIndexDef != null && !indexDef.isMandatorySystemIndex()) {
                tableData.update(oldIndexDef, 17);
            }
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return " ";
            }
            case 1: {
                return VWResource.IndexName;
            }
            case 2: {
                return VWResource.IndexKey;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWConfigTableModelData tableData = null;
        VWIndexDefinition indexDef = null;
        try {
            tableData = this.getRowItemAt(nRowIndex);
            if (tableData != null) {
                indexDef = (VWIndexDefinition)tableData.getDefinition();
            }
            switch (nColumnIndex) {
                case 0: {
                    if (tableData != null) {
                        return tableData.getStatus();
                    }
                    return 0;
                }
                case 1: {
                    if (indexDef != null) {
                        return indexDef.getName();
                    }
                    return "";
                }
                case 2: {
                    if (indexDef != null) {
                        return indexDef.getFieldNames();
                    }
                    return "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_vwTableDef = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    public boolean getCanDeleteRow(int nRowIndex) {
        boolean bCanDelete = true;
        try {
            VWIndexDefinition idxDef = this.getIndexItemAt(nRowIndex);
            if (idxDef == null || idxDef.isSystemIndex()) {
                bCanDelete = false;
            }
        }
        catch (Exception ex) {
            bCanDelete = false;
            VWDebug.logException(ex);
        }
        return bCanDelete;
    }

    private void initialize() {
        VWIndexDefinition[] indexDefs = null;
        VWConfigTableModelData tableData = null;
        try {
            this.m_rowData = new Vector();
            indexDefs = this.m_vwTableDef.getIndexes();
            if (indexDefs != null) {
                for (int nIndex = 0; nIndex < indexDefs.length; ++nIndex) {
                    tableData = new VWConfigTableModelData(indexDefs[nIndex], 0);
                    if (tableData == null) continue;
                    this.m_rowData.addElement(tableData);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWConfigTableModelData getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWConfigTableModelData)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }
}

